import 'package:amazcart/controller/settings_controller.dart';
import 'package:get/get.dart';

class AppUtilities{

  static double convertToDouble({required  item}){
    if(item == null){
      return 0;
    }
    String temp = item.toString();
    return double.tryParse(temp)??0;
  }

  static int? convertToInt({required  item}){
    return int.tryParse("${item}");
  }


  static DateTime convertToDateTime({required String? dateTime}){
    return (DateTime.tryParse(dateTime??"")??DateTime.now()).toLocal();
  }

  static getDecimalLimit(){
    try{
      return Get.find<GeneralSettingsController>().decimalLimit;
    }catch(e){
      return 0;
    }
  }

}